﻿/*
	VERSION:		2.4
	2.4		Fix: 			recurseClips() was being used wrong
	2.3		Change:		Use recurseClip.as
	
	
	USAGE:
		#include "functions/callUnload.as"
		callUnload( my_mc );
		my_mc.removeMovieClip();
	
	WHAT IT'S FOR:
		This recursively calls EVERY unload function and unload event within the target and its children.
		"unload" functions and events don't always automatically fire, so this is used to force-fire them.
*/
callUnload = function( parent ){
	#include "functions/recurseClips.as"
	
	// affect all children and self
	recurseClips( parent, unloadThis );
	
	function unloadThis( thisItem ){
		thisItem.onKillFocus(null);									// causes components to remove their internal listeners
		thisItem.dispatchEvent({type:"unload"});		// component unload event
		thisItem.broadcastMessage("unload");				// broadcaster unload event
		thisItem.unload();													// manual component unload()
		thisItem.onUnload();												// manual movieClip onUnload()		This typically also triggers an "unload" event.  My RPG actually relies on the 2nd event to successfully interrupt movement commands, because they are not detected during the 1st "unload" event for some reason.
		delete thisItem.onUnload;										// remove this so that removeMovieClip() takes effect instantly  (it doesn't need to get called twice anyway)
		// remove common listeners just in case
		thisItem.removeEventListener("keyDown", thisItem);
		thisItem.removeEventListener("keyUp", thisItem);
		Key.removeListener(thisItem);
		Mouse.removeListener(thisItem);
		// remove all other listeners
		for(var L in thisItem._listeners){
			var thisListener = thisItem._listeners[L];
			thisItem.removeListener( thisListener );
			// delete thisListener;
		}// for:  each listener
		
		// destroy this MovieClip's addListener() so that nothing can listen to it after being unloaded
		thisItem.addListener = function(){}		// a function named "addListener" MUST exist for "unload" events to be detectable
	}// unloadThis()
	
}// callUnload()